#include "servodriver.h"

//////////////Constructors///////////////
servo_driver::servo_driver()
{
  servo_driver("/dev/ttyUSB0");
}

servo_driver::servo_driver(string pn)
{
  portname = pn;
  serial_open();
}

void servo_driver::serial_open()
{
  port.open(portname.c_str());
  if(port.fail())
  {
    cout << "Error: " << portname << " could not be opened!" << endl;
  }
}
/////////////////////////////////////////

/////////////////Getters/////////////////
string servo_driver::get_port_name()
{
  return portname;
}

char servo_driver::get_motor1_speed()
{
  return motor1_speed;
}

char servo_driver::get_motor2_speed()
{
  return motor2_speed;
}

char servo_driver::get_motor1_limit()
{
  return motor1_limit;
}

char servo_driver::get_motor2_limit()
{
  return motor2_limit;
}
/////////////////////////////////////////

////////////////Setters/////////////////
void servo_driver::set_motors(char m1, char m2)
{
  motor1_speed = m1;
  motor2_speed = m2;
  set_motors();
}

void servo_driver::set_motors()
{
  char buffer[4] = {255, motor1_speed, motor2_speed, 200}; //Update command
  port.write(buffer,4);
  port.flush();
}

void servo_driver::set_limits(char m1l, char m2l)
{
  motor1_limit = m1l;
  motor2_limit = m2l;
  set_limits();
}

void servo_driver::set_limits()
{
  char buffer[4] = {254, motor1_limit, motor2_limit, 200}; //Update limits command
  //write(portfd, buffer, 4);
}
/////////////////////////////////////////

/////////////Basic Setters///////////////
void servo_driver::set_motor1_speed(char m1)
{
  motor1_speed = m1;
}

void servo_driver::set_motor2_speed(char m2)
{
  motor2_speed = m2;
}

void servo_driver::set_motor1_limit(char m1l)
{
  motor1_limit = m1l;
}

void servo_driver::set_motor2_limit(char m2l)
{
  motor2_limit = m2l;
}
/////////////////////////////////////////
